
#################### Ozabaci, Henderson, and Su's (2014) procedure ####################

########## 1st stage ##########

Dat.1=Dat[-c(1)]
iv=Dat.1[c(2)]

iv=as.matrix(iv)
n=nrow(Dat)
knots=floor(2*n^(1/5)+3)
iv.s=bs(iv,df=knots)

colnames(iv.s)=c("b1","b2","b3","b4","b5","b6","b7","b8","b9","b10","b11","b12","b13")

dat.11=Dat.1[-c(2)]
dat.1=cbind(iv.s,dat.11)

ols=lm(wheat_aid~.,data=dat.1)
res=residuals(ols)
res=as.matrix(res)

summary(ols) # check which variables are removed due to collinearity #

########## weak IV test with the robust standard errors ##########

dat.1$clusterid=id

fs <- lm(wheat_aid~.-b13-indicator-clusterid,data=dat.1) # b13 and indicator are removed due to collinearity #
fn <- lm(wheat_aid~.-b1-b2-b3-b4-b5-b6-b7-b8-b9-b10-b11-b12-b13-indicator-clusterid,data=dat.1)

########## statistic and p-value ##########

waldtest(fs,fn,vcov=clusterVCV(dat.1,fs,cluster1="clusterid"))$F[2]
waldtest(fs,fn,vcov=clusterVCV(dat.1,fs,cluster1="clusterid"))$Pr[2]
